DELIMITER $$
DROP PROCEDURE IF EXISTS V20220404160258__Update_RegistrationDocumentGridAdded $$
CREATE PROCEDURE V20220404160258__Update_RegistrationDocumentGridAdded()
BEGIN

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((SELECT * FROM dtprovider WHERE `dataProviderName`='REGISTRATION_POST_AUTHORIZATION_DL')) THEN 
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REGISTRATION_POST_AUTHORIZATION_DL');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery`=
"SELECT DISTINCT
    T3.userId AS USER_ID,
	T7.id AS DLS_PROGRAM_BATCH_SEAT_CONFIG_ID
FROM
    program_batch_students T1
        LEFT OUTER JOIN
    admission T2 ON T1.admissionId = T2.id
        LEFT OUTER JOIN
    students T3 ON T2.studentId = T3.userId
        LEFT OUTER JOIN
    batches T4 ON T1.programBatchId = T4.id
        LEFT OUTER JOIN
    programs T5 ON T4.programId = T5.id
        LEFT OUTER JOIN
    prog_batch_period_config T6 ON T1.progBatchPeriodConfigId = T6.id
		LEFT OUTER JOIN
	prog_batch_seat_config T7 on T7.id = T1.progBatchSeatConfigId
WHERE T1.isCurrentPeriod=true AND T1.isCurrentSection=true AND T1.exitDate is null
AND T2.id in(namedParams)" WHERE (`dataProviderId` = @dtproviderId);
END IF; 
SET SQL_SAFE_UPDATES=1;

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select T1.id from `sys_msg_evtrcpt_default_conf` T1 left join `sys_msg_evt_default_conf` T2 on T1.sysMsgEvtDefaultConfId = T2.id left join `system_msg_event` T3 on T2.systemMsgEventId = T3.id where T3.code = 'REGISTRATION_POST_AUTHORIZATION')) THEN 
SET @sysmsgevtrcptdefaultconfId=(select T1.id from `sys_msg_evtrcpt_default_conf` T1 left join `sys_msg_evt_default_conf` T2 on T1.sysMsgEvtDefaultConfId = T2.id left join `system_msg_event`
T3 on T2.systemMsgEventId = T3.id where T3.code = 'REGISTRATION_POST_AUTHORIZATION');
UPDATE `sys_msg_evt_rcpnt_doc` SET `docGenParamMapDef` = '[{\"MSG_PARAM\":\"CONTEXT_RECORD_ID\",\"DOC_GEN_PARAM\":\"PRM_ADMISSION_ID\"}]' WHERE (`sysMsgEvtRcpntDefaultConfigId` = @sysmsgevtrcptdefaultconfId);
END IF; 
SET SQL_SAFE_UPDATES=1;

SET SQL_SAFE_UPDATES=0;
IF EXISTS ((select * from `dydt_data_line_item` WHERE dataSourceCode ='REGISTRATION_POST_AUTHORIZATION_INFO')) THEN 
UPDATE `dydt_data_line_item` SET `whereClauseBindingDef` = 'PRM_ADMISSION_ID', `sqlWhereQueryDef` = 'WHERE T2.id=PRM_ADMISSION_ID AND T1.isCurrentPeriod=true 
AND T1.isCurrentSection=true AND T1.exitDate is null group by T3.userId' WHERE dataSourceCode ='REGISTRATION_POST_AUTHORIZATION_INFO';
END IF; 
SET SQL_SAFE_UPDATES=1;

SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
SET @dydtdataproviderId = (SELECT dataProviderId FROM `dydt_data_line_item` where dataSourceCode='REGISTRATION_POST_AUTHORIZATION_INFO');
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`)
VALUES (@dydtdatalinitemId+1, @dydtdataproviderId, 'STUDENT_COURSE_ENROLLMENT_INFO', '2',null, '1', '0', 
'SELECT c.courseCode AS COURSE_CODE , 
c.courseName AS COURSE_NAME, 
c.courseCredits AS COURSE_CREDITS, 
pbpc.printName AS PERIOD
from student_course_enrollment sce
inner join prog_batch_period_config pbpc on sce.programBatchPeriodConfigId=pbpc.id
inner join admission adm on adm.id=sce.admissionId
inner join course_variants cv on cv.id=sce.courseVarientId
left join courses c on c.id=cv.courseId', 'PRM_ADMISSION_ID', 
	'COURSE_CODE, COURSE_NAME, COURSE_CREDITS, PERIOD',
'where adm.id=PRM_ADMISSION_ID and sce.programBatchPeriodConfigId>=(
select pbs.progBatchPeriodConfigId from program_batch_students pbs where pbs.admissionId=PRM_ADMISSION_ID and pbs.isCurrentPeriod=true and pbs.isCurrentSection=true and 
pbs.exitDate is null
) and sce.exitDate is null and adm.activeStatus=true', '1');

INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_CODE', 'Course Code',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_NAME', 'Course Name',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COURSE_CREDITS', 'Credits',@dydtdatalinitemId+1);
INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PERIOD', 'Period',@dydtdatalinitemId+1);


END $$
CALL V20220404160258__Update_RegistrationDocumentGridAdded () $$
DROP PROCEDURE IF EXISTS V20220404160258__Update_RegistrationDocumentGridAdded $$
DELIMITER ;